% Copyright (c) 2016 Giampaolo D'Alessandro
% Mathematical Sciences - University of Southampton
% Email: dales@soton.ac.uk
% 
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to deal
% in the Software without restriction, including without limitation the rights
% to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
% copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
% 
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
% 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.

% Script to plot the diffraction efficiency as a function of voltage.
C_num = [0 0.2 0.4 0.6 0.8 1.0 1.3];
% When using sigma_pump=300e-6 and sigma_probe=300e-6
% Obtained from running scripts Fig8a-h
eta_num = [0.003 0.0044 0.007 0.0103 0.0138 0.0170 0.0225];  
lambda_probe_dim = 633e-9;    %Probe wavelength
I_0 = 19.5;     % Power of the input beam in W cm^{-2}
L_LC = 50e-6;     % Cell thickness in metres
Probe_beam_angleInDegrees = 15;
Probe_beam_angle = degtorad(Probe_beam_angleInDegrees);

sqrt_eta_num = sqrt(eta_num);
n2_num = sqrt_eta_num*lambda_probe_dim*cos(Probe_beam_angle)/(I_0 *pi*L_LC);
C_exp = [0 0.2 0.4 0.6 0.8 1.0 1.3];            % Experimental
n2_exp = [0 1 1.5 2.1 2.35 2.9 3.1]*1e-5;       % Experimental

FontName='Times';
FontSize=24;
FontAngle='normal'; %'italic';
LineWidth=2;
MarkerSize=12;  % In points (72 points per inch)

figure(10); clf;
set(gcf,'PaperOrientation','Landscape','PaperType','A4',...
  'PaperUnits','normalized','PaperPosition',[0 0 1 1]);
axes('Parent',gcf,...
  'YMinorTick','on','XMinorTick','on',...
  'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
hold(gca,'all');
plot(C_exp,n2_exp,'dr','MarkerSize',MarkerSize,...
  'DisplayName','Experiment','LineWidth',LineWidth);
plot(C_num,n2_num,'b-','LineWidth',LineWidth,...
  'DisplayName','Theory');
axis([0,1.5,0,0.4e-4]);
xlabel('Concentration of gold nanoparticles [%wt]');
ylabel('|n_2| [cm^2/W]');
legend(gca,'Location','SouthEast');
% title('Nonlinear refractive index vs nanoparticle concentration');
text(1.2,0.15,'\sigma_{pump}= 400\mum',...
  'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
text(1.2,0.17,'Glass thickness = 500\mum',...
  'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
text(1.2,0.19,'Glass therm. cond. = 1 W K^{-1} m^{-1}',...
  'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
saveas(gcf,'DiffEffConc','pdf');
saveas(gcf,'DiffEffConc','png');